/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.gagravarr.ogg.IOUtils;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketData;
import org.gagravarr.ogg.OggPacketReader;
import org.gagravarr.ogg.OggPage;

public class TestReadBoundaries
extends TestCase {
    private InputStream getTestFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testBoundaries.ogg");
    }

    public static byte[] getBytes(int len) {
        byte[] b = new byte[len];
        for (int i = 0; i < len; ++i) {
            b[i] = IOUtils.fromInt(i % 256);
        }
        return b;
    }

    private static void assertEquals(byte[] a, byte[] b) {
        TestReadBoundaries.assertNotNull((Object)a);
        TestReadBoundaries.assertNotNull((Object)b);
        TestReadBoundaries.assertEquals((int)a.length, (int)b.length);
        for (int i = 0; i < a.length; ++i) {
            TestReadBoundaries.assertEquals((byte)a[i], (byte)b[i]);
        }
    }

    private void doTest(OggPacketReader r) throws IOException {
        OggPacket p = r.getNextPacket();
        TestReadBoundaries.assertEquals((int)4660, (int)p.getSid());
        TestReadBoundaries.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadBoundaries.assertEquals((int)0, (int)p.getSequenceNumber());
        TestReadBoundaries.assertEquals((boolean)true, (boolean)p.isBeginningOfStream());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadBoundaries.assertEquals((int)6, (int)p.getData().length);
        TestReadBoundaries.assertEquals(new byte[]{0, 1, 2, 3, 4, 5}, p.getData());
        p = r.getNextPacket();
        TestReadBoundaries.assertEquals((int)4660, (int)p.getSid());
        TestReadBoundaries.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadBoundaries.assertEquals((int)1, (int)p.getSequenceNumber());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadBoundaries.assertEquals((int)6, (int)p.getData().length);
        TestReadBoundaries.assertEquals(new byte[]{0, 1, 2, 3, 4, 5}, p.getData());
        p = r.getNextPacket();
        TestReadBoundaries.assertEquals((int)4660, (int)p.getSid());
        TestReadBoundaries.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadBoundaries.assertEquals((int)1, (int)p.getSequenceNumber());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.isEndOfStream());
        TestReadBoundaries.assertEquals((int)6, (int)p.getData().length);
        TestReadBoundaries.assertEquals(new byte[]{10, 11, 12, 13, 14, 15}, p.getData());
        p = r.getNextPacket();
        TestReadBoundaries.assertEquals((int)4660, (int)p.getSid());
        TestReadBoundaries.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadBoundaries.assertEquals((int)2, (int)p.getSequenceNumber());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.isBeginningOfStream());
        TestReadBoundaries.assertEquals((boolean)true, (boolean)p.isEndOfStream());
        TestReadBoundaries.assertEquals((int)1028, (int)p.getData().length);
        TestReadBoundaries.assertEquals(TestReadBoundaries.getBytes(1028), p.getData());
    }

    public void testPages() throws IOException {
        InputStream i = this.getTestFile();
        i.read();
        i.read();
        i.read();
        i.read();
        OggPage p = new OggPage(i);
        TestReadBoundaries.assertEquals((int)1, (int)p.getNumLVs());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.isContinuation());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.hasContinuation());
        OggPage.OggPacketIterator it = p.getPacketIterator();
        TestReadBoundaries.assertEquals((boolean)true, (boolean)it.hasNext());
        OggPacketData d = it.next();
        TestReadBoundaries.assertEquals((int)6, (int)d.getData().length);
        TestReadBoundaries.assertEquals((boolean)false, (boolean)it.hasNext());
        i.read();
        i.read();
        i.read();
        i.read();
        p = new OggPage(i);
        TestReadBoundaries.assertEquals((int)5, (int)p.getNumLVs());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.isContinuation());
        TestReadBoundaries.assertEquals((boolean)true, (boolean)p.hasContinuation());
        it = p.getPacketIterator();
        TestReadBoundaries.assertEquals((boolean)true, (boolean)it.hasNext());
        d = it.next();
        TestReadBoundaries.assertEquals((int)6, (int)d.getData().length);
        TestReadBoundaries.assertEquals((boolean)true, (boolean)it.hasNext());
        d = it.next();
        TestReadBoundaries.assertEquals((int)6, (int)d.getData().length);
        TestReadBoundaries.assertEquals((boolean)true, (boolean)it.hasNext());
        d = it.next();
        TestReadBoundaries.assertEquals((int)765, (int)d.getData().length);
        TestReadBoundaries.assertEquals((boolean)false, (boolean)it.hasNext());
        i.read();
        i.read();
        i.read();
        i.read();
        p = new OggPage(i);
        TestReadBoundaries.assertEquals((int)2, (int)p.getNumLVs());
        TestReadBoundaries.assertEquals((boolean)true, (boolean)p.isContinuation());
        TestReadBoundaries.assertEquals((boolean)false, (boolean)p.hasContinuation());
        it = p.getPacketIterator();
        TestReadBoundaries.assertEquals((boolean)true, (boolean)it.hasNext());
        d = it.next();
        TestReadBoundaries.assertEquals((int)263, (int)d.getData().length);
        TestReadBoundaries.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testProcessRaw() throws IOException {
        OggPacketReader r = new OggPacketReader(this.getTestFile());
        this.doTest(r);
    }

    public void testProcessOggFile() throws IOException {
        OggFile ogg = new OggFile(this.getTestFile());
        OggPacketReader r = ogg.getPacketReader();
        this.doTest(r);
    }
}

