/*
 * Decompiled with CFR 0.152.
 */
package adql.db;

import adql.db.DBColumn;
import adql.db.DBCommonColumn;
import adql.db.DBIdentifier;
import adql.db.DBTable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultDBTable
extends DBIdentifier
implements DBTable {
    protected String dbCatalogName = null;
    protected String dbSchemaName = null;
    protected String adqlCatalogName = null;
    protected String adqlSchemaName = null;
    protected Map<String, DBColumn> columns = new LinkedHashMap<String, DBColumn>();

    public DefaultDBTable(String adqlName) throws NullPointerException {
        super(adqlName);
    }

    public DefaultDBTable(String adqlName, String dbName) throws NullPointerException {
        super(adqlName, dbName);
    }

    public DefaultDBTable(String adqlCatName, String adqlSchemaName, String adqlName) throws NullPointerException {
        this(adqlCatName, null, adqlSchemaName, null, adqlName, null);
    }

    public DefaultDBTable(String adqlCatName, String dbCatName, String adqlSchemaName, String dbSchemaName, String adqlName, String dbName) throws NullPointerException {
        super(adqlName, dbName);
        this.setADQLSchemaName(adqlSchemaName);
        this.setDBSchemaName(dbSchemaName);
        this.setADQLCatalogName(adqlCatName);
        this.setDBCatalogName(dbCatName);
    }

    @Override
    public final String getDBSchemaName() {
        return this.dbSchemaName == null ? this.adqlSchemaName : this.dbSchemaName;
    }

    public final void setDBSchemaName(String name) {
        this.dbSchemaName = DefaultDBTable.normalize(name);
    }

    @Override
    public final String getDBCatalogName() {
        return this.dbCatalogName == null ? this.adqlCatalogName : this.dbCatalogName;
    }

    public final void setDBCatalogName(String name) {
        this.dbCatalogName = DefaultDBTable.normalize(name);
    }

    @Override
    public final String getADQLSchemaName() {
        return this.adqlSchemaName;
    }

    public void setADQLSchemaName(String name) {
        this.adqlSchemaName = DefaultDBTable.normalize(name);
    }

    @Override
    public final String getADQLCatalogName() {
        return this.adqlCatalogName;
    }

    public void setADQLCatalogName(String name) {
        this.adqlCatalogName = DefaultDBTable.normalize(this.dbName);
    }

    @Override
    public DBColumn getColumn(String colName, boolean byAdqlName) {
        if (byAdqlName) {
            return this.columns.get(colName);
        }
        for (DBColumn col : this.columns.values()) {
            if (!col.getDBName().equals(colName)) continue;
            return col;
        }
        return null;
    }

    public boolean hasColumn(String colName, boolean byAdqlName) {
        return this.getColumn(colName, byAdqlName) != null;
    }

    @Override
    public Iterator<DBColumn> iterator() {
        return this.columns.values().iterator();
    }

    public void addColumn(DBColumn column) {
        if (column != null) {
            this.columns.put(column.getADQLName(), column);
        }
    }

    public void addAllColumns(Collection<DBColumn> colList) {
        if (colList != null) {
            for (DBColumn column : colList) {
                this.addColumn(column);
            }
        }
    }

    @Deprecated
    public static final String[] splitTableName(String table) {
        String[] splitRes = new String[]{null, null, null};
        if (table == null || table.trim().length() == 0) {
            return splitRes;
        }
        String[] names = table.trim().split("\\.");
        switch (names.length) {
            case 1: {
                splitRes[2] = table.trim();
                break;
            }
            case 2: {
                splitRes[2] = names[1].trim();
                splitRes[1] = names[0].trim();
                break;
            }
            case 3: {
                splitRes[2] = names[2].trim();
                splitRes[1] = names[1].trim();
                splitRes[0] = names[0].trim();
                break;
            }
            default: {
                splitRes[2] = names[names.length - 1].trim();
                splitRes[1] = names[names.length - 2].trim();
                StringBuffer buff = new StringBuffer(names[0].trim());
                for (int i = 1; i < names.length - 2; ++i) {
                    buff.append('.').append(names[i].trim());
                }
                splitRes[0] = buff.toString();
            }
        }
        return splitRes;
    }

    @Deprecated
    public static final String joinTableName(String[] nameParts) {
        int i;
        if (nameParts == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        boolean empty = true;
        int n = i = nameParts.length <= 3 ? 0 : nameParts.length - 3;
        while (i < nameParts.length) {
            String part;
            if (!empty) {
                str.append('.');
            }
            String string = part = nameParts[i] == null ? null : nameParts[i].trim();
            if (part != null && part.length() > 0) {
                str.append(part);
                empty = false;
            }
            ++i;
        }
        return str.toString();
    }

    @Override
    public DBTable copy(String dbName, String adqlName) {
        DefaultDBTable copy = new DefaultDBTable(this.adqlCatalogName, this.dbCatalogName, this.adqlSchemaName, this.dbSchemaName, adqlName, dbName);
        copy.setCaseSensitive(this.isCaseSensitive());
        for (DBColumn col : this) {
            if (col instanceof DBCommonColumn) {
                copy.addColumn(new DBCommonColumn((DBCommonColumn)col, col.getDBName(), col.getADQLName()));
                continue;
            }
            copy.addColumn(col.copy(col.getDBName(), col.getADQLName(), copy));
        }
        return copy;
    }
}

